function default_probs = default_probs_cds2(cds, maturities, start_date_num, end_date_num, ajd_common, y0)
% --------------------------------------------------------------------------------------------------
% Calculate risk-neutral survival and default probability for each (future) coupon payment date.
% --------------------------------------------------------------------------------------------------
% cds             ... structure containing credit default swap time series (see 'all_steps_in_a_row.m')
% maturities      ... indicator vector which maturities to include in the calculation, default: all
% ajd_common      ... dynamics of common factor
% y0              ... initial value(s) of common factor
% --------------------------------------------------------------------------------------------------
% sample call: default_probs_cds2(cds_test)
% --------------------------------------------------------------------------------------------------

% Determine relevant date range
start_pos = find(cds.dates{1} >= start_date_num, 1, 'first');
end_pos = find(cds.dates{1} <= end_date_num, 1, 'last');
used_range = start_pos:end_pos;
if (isempty(used_range))
    default_probs = struct('dates', []);
    return;
end
used_dates = cds.dates{1}(used_range);
num_dates = length(used_dates);

% Determine relevant date range for maxium horizon to be priced
tmp = [5 7 10 1];
max_pos = find(tmp == max(tmp(logical(maturities))));
start_pos_max = find(cds.dates{max_pos} >= start_date_num, 1, 'first');
end_pos_max = find(cds.dates{max_pos} <= end_date_num, 1, 'last');
used_range_max = start_pos_max:end_pos_max;

% Determine maximum horizon of interest
if (length(used_range_max) == length(used_range))
    horizons = cds.T{1}(used_range) + ceil((max(cds.T{max_pos}(used_range_max)) - max(cds.T{1}(used_range)))*4)/4;
else
    horizons = cds.T{1}(used_range) + (tmp(max_pos) - tmp(1));
end

% Cut down time series of parameters to relevant range & calculate idiosyncratic survival probability
[k,theta,sigma,L,mu,x0] = generate_parameter_time_series(cds.AJD, used_dates, cds.x0);
bi = cds.bi(used_range,1);
surv_probs_idio = mgf_intAJD_c(x0, k, theta, sigma, L, mu, horizons, -bi);

% Cut down time series of parameters to relevant range & calculate idiosyncratic survival probability
[k,theta,sigma,L,mu,y0] = generate_parameter_time_series(ajd_common, used_dates, y0);
ai = cds.ai(used_range,1);
surv_probs_sys = mgf_intAJD_c(y0, k, theta, sigma, L, mu, horizons, -ai);

% Combine idiosyncratic and systmatic survival probability
surv_probs = surv_probs_idio .* surv_probs_sys;
default_probs = [ones(num_dates, 1) surv_probs(:,1:end-1)] - surv_probs;

% Return structure with dates and default probabilities
default_probs = struct('dates', {used_dates}, 'default_probs', default_probs, 'surv_probs', surv_probs);
